<?php

if (!defined('ABSPATH')) {
    exit; // Exit if accessed directly.
}

class Ultimate_AI_Category_API
{
    public $CATEGORY_MANAGER;

    public function __construct()
    {
        $this->CATEGORY_MANAGER = new Ultimate_AI_Category();
        add_action('wp_ajax_ultimate_ai_create_category', [$this, 'ultimate_ai_create_category']);
        add_action('wp_ajax_ultimate_ai_delete_category', [$this, 'ultimate_ai_delete_category']);
        add_action('wp_ajax_ultimate_ai_read_all_categories', [$this, 'ultimate_ai_read_all_categories']);
        add_action('wp_ajax_ultimate_ai_update_category_meta', [$this, 'ultimate_ai_update_category_meta']);
    }

	public function ultimate_ai_update_category_meta() {
		$this->must_fields_error(["field","value","id"]);
		$this->restrict_req_for_admin();

		$field = sanitize_key( $_POST["field"] );
		$value = sanitize_text_field( $_POST["value"] );
		$id = (int)sanitize_text_field( $_POST["id"] );
		//if bool string then convert bool from string to bool
		$value = $value == "true" ? true : ($value == "false" ? false : $value);

		$res = $this->CATEGORY_MANAGER->update_meta_field( $id, $field, $value );
		wp_send_json([ "data" => $res ], 200 );
	}

    // ============ Create category  =============================
    public function ultimate_ai_create_category()
    {
		$this->must_fields_error(["name", "description"]);
		$this->restrict_req_for_admin();

        $name = sanitize_text_field($_POST['name'] ?? '');
        $desc= sanitize_text_field($_POST['description'] ?? '');
        $tool_ids = map_deep( $_POST['tools'], "sanitize_text_field" ) ?? [];
        $tools = [];
		$cat_id = (int)sanitize_text_field( $_POST["id"] ?? "0" );
        foreach ( $tool_ids as $id) { $tools[] = (int) $id; }
        $res = $this->CATEGORY_MANAGER->create_category( $name, $desc, $tools, $cat_id );

		if(! $res["success"] ) wp_send_json([ "data" => $res["message"]], 400 );
		wp_send_json([ "data" => $res["data"]], 200 );
    }

    // ============ Read all category List =============================
    public function ultimate_ai_read_all_categories()
    {
        $categories_data = $this->CATEGORY_MANAGER->read_all_categories();

        if (!$categories_data['success']) {
            wp_send_json(['data' => 'Failed to retrieve categories.'], 400);
        }

        wp_send_json($categories_data, 200);
    }

    // ========= Delete category =========================
    public function ultimate_ai_delete_category()
    {
		$this->must_fields_error(["category_id"]);
		$this->restrict_req_for_admin();

        $category_id = (int) sanitize_text_field($_POST["category_id"]);
//		var_dump($category_id);
		$delete_result = $this->CATEGORY_MANAGER->delete_category($category_id);

		if (!$delete_result['success']) {
			wp_send_json(['data' => 'Category deletion failed. '.$delete_result['message']], 400);
		}

		wp_send_json(['data' => 'Category deleted successfully'], 200);
    }


	private function restrict_req_for_admin( ) {
		if( !current_user_can("edit_pages") ) {
			wp_send_json("Not authorized", 401);
		}
	}


	private function must_fields_error( $must_fields ) {
		foreach( $must_fields as $field ) {
			if( !$_POST[ $field ] || empty( $_POST[ $field ] ) ) {
				wp_send_json( array( "data" => esc_html__("Send proper information.", ULTIMATE_AI_SLUG) ), 400 );
			}
		}
	}

}

new Ultimate_AI_Category_API();
